/* Coffre fort à combinaison 
Version française du sketch Combination Safe 
*/

/* Combination Safe
 Written by Becky Stewart
 For Adventures in Arduino, Wiley (2015)
 
 Hardware:
 * 3 10 kOhm potentiometers
 * pushbutton
 * servo
 
Copyright 2015 Becky Stewart

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

 */

#include <Servo.h>
// Les broches
int brochePot1 = A0;
int brochePot2 = A1;
int brochePot3 = A2;
int brocheBouton = 7;
int brocheServo = 9;

// Autres variables
int ouverture1 = 0;
int ouverture2 = 1023;
int ouverture3 = 0;
int ecart = 10;
int boiteOuverte = 0;
Servo servo;

void setup() {
  // mettre ici le code d'initialisation qui sera exécuté
  // une seule fois
  // la broche du poussoir est une entrée avec résistance de
  // maintien
  pinMode(brocheBouton, INPUT_PULLUP);
  // attacher le servo à sa broche
  servo.attach(brocheServo); // attache le servo à la broche 9
  servo.write(90); // démarrer avec la boîte fermée
  Serial.begin(9600); // démarrer la transmission série
}

void loop() {
  // vérifier si le bouton est appuyé
  int valeurBouton = digitalRead(brocheBouton);
  // si le bouton est pressé et que la boîte est fermée
  if(valeurBouton == 0 && boiteOuverte == 0)
    {
    // le bouton est appuyé
    int valeurPot1 = analogRead(brochePot1);
    int valeurPot2 = analogRead(brochePot2);
    int valeurPot3 = analogRead(brochePot3);
    Serial.print("pot 1: ");
    Serial.print(valeurPot1);
    Serial.print(" pot 2: ");
    Serial.print(valeurPot2);
    Serial.print(" pot 3: ");
    Serial.println(valeurPot3);
    
    // si toutes les valeurs sont dans les écarts permis
    if(valeurPot1< (ouverture1+ecart) &&
      valeurPot1> (ouverture1-ecart) &&
      valeurPot2< (ouverture2+ ecart) &&
      valeurPot2> (ouverture2- ecart) &&
      valeurPot3< (ouverture3+ ecart) &&
      valeurPot3> (ouverture3- ecart))
      {
        
      // ouvrir la boîte
      Serial.println("ouverture");
      for(int pos = 90; pos > 0; pos -= 1)
        {
        servo.write(pos);
        delay(15);
        }
      boiteOuverte = 1;
      }
    }
  // si le bouton est relâché et que la boîte est ouverte
  if(valeurBouton==1 && boiteOuverte==1)
    {
    Serial.println("fermeture ");
    // fermer la boîte
    for(int pos = 0; pos < 90; pos+=1)
      {
      servo.write(pos);
      delay(15);
      }
    boiteOuverte = 0;
  }
}
